<?php
$items = fg_get_gallery_items();
?>
<div class="container py-5 custom-gallery-section">
    <div class="row">
        <?php foreach ($items as $item): 
            $caption = get_the_title($item->ID);
            $image = get_field('gallery_image', $item->ID);

            // Default empty
            $image_url = '';
            $full_url = '';

            // Handle based on return type
            if (is_array($image)) {
                // Return format = Image Array
                $image_url = $image['sizes']['medium'] ?? $image['url'];
                $full_url = $image['url'];
            } elseif (is_numeric($image)) {
                // Return format = Image ID
                $image_src = wp_get_attachment_image_src($image, 'medium');
                $image_url = $image_src[0] ?? '';
                $full_url_data = wp_get_attachment_image_src($image, 'full');
                $full_url = $full_url_data[0] ?? '';
            } elseif (is_string($image)) {
                // Return format = Image URL
                $image_url = $image;
                $full_url = $image;
            }
        ?>
        <div class="col-md-3 col-sm-6 mb-4 gallery-item">
            <?php if ($image_url && $full_url): ?>
            <a href="<?= esc_url($full_url) ?>" data-fancybox="gallery" data-caption="<?= esc_attr($caption) ?>">
                <div class="image-wrapper" data-title="<?= esc_attr($caption) ?>">
                    <img src="<?= esc_url($image_url) ?>" alt="<?= esc_attr($caption) ?>">
                    <div class="overlay"><i class="fa fa-search-plus"></i></div>
                </div>
            </a>
            <?php else: ?>
            <p>⚠️ No image found for post ID <?= $item->ID ?></p>
            <?php endif; ?>
            <p class="image-title" title="<?= esc_attr($caption) ?>"><?= esc_html($caption) ?></p>
        </div>
        <?php endforeach; ?>
    </div>
</div>
