<?php $items = fg_get_gallery_items(); ?>
<div class="container py-5 custom-gallery-section">
    <div class="row">
        <?php foreach ($items as $item): 
            $image = get_the_post_thumbnail_url($item->ID, 'medium');
            $full = get_the_post_thumbnail_url($item->ID, 'full');
            $caption = esc_attr($item->post_title);
        ?>
        <div class="col-md-3 col-sm-6 mb-4 gallery-item">
            <a href="<?= $full ?>" data-fancybox="gallery" data-caption="<?= $caption ?>">
                <div class="image-wrapper" data-title="<?= $caption ?>">
                    <img src="<?= $image ?>" alt="<?= $caption ?>">
                    <div class="overlay"><i class="fa fa-search-plus"></i></div>
                </div>
            </a>
            <p class="image-title" title="<?= $caption ?>"><?= $caption ?></p>
        </div>
        <?php endforeach; ?>
    </div>
</div>
