<?php
// Create admin menu
function fg_add_admin_menu() {
    add_menu_page(
        'Fancybox Gallery Settings',
        'Gallery Settings',
        'manage_options',
        'fg-gallery-settings',
        'fg_gallery_settings_page',
        'dashicons-format-gallery',
        100
    );
}
add_action('admin_menu', 'fg_add_admin_menu');

// Register settings
function fg_register_settings() {
    register_setting('fg_gallery_settings_group', 'fg_enable_fancybox');
    register_setting('fg_gallery_settings_group', 'fg_enable_video');
    register_setting('fg_gallery_settings_group', 'fg_allowed_roles');
}
add_action('admin_init', 'fg_register_settings');

// Settings page HTML
function fg_gallery_settings_page() {
    $roles = wp_roles()->roles;
    $enabled_roles = get_option('fg_allowed_roles', []);
    ?>
    <div class="wrap">
        <h1>Fancybox Gallery Settings</h1>
        <form method="post" action="options.php">
            <?php settings_fields('fg_gallery_settings_group'); ?>
            <?php do_settings_sections('fg_gallery_settings_group'); ?>

            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Enable FancyBox</th>
                    <td><input type="checkbox" name="fg_enable_fancybox" value="1" <?php checked(1, get_option('fg_enable_fancybox', 1)); ?>></td>
                </tr>

                <tr valign="top">
                    <th scope="row">Enable Video Support</th>
                    <td><input type="checkbox" name="fg_enable_video" value="1" <?php checked(1, get_option('fg_enable_video', 1)); ?>></td>
                </tr>

                <tr valign="top">
                    <th scope="row">Allowed Roles for Managing Galleries</th>
                    <td>
                        <?php foreach ($roles as $key => $role): ?>
                            <label>
                                <input type="checkbox" name="fg_allowed_roles[]" value="<?php echo esc_attr($key); ?>"
                                <?php checked(in_array($key, $enabled_roles)); ?>>
                                <?php echo esc_html($role['name']); ?>
                            </label><br>
                        <?php endforeach; ?>
                    </td>
                </tr>
            </table>

            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}
// Restrict gallery menu access based on selected roles
function fg_restrict_gallery_menu_access() {
    $allowed_roles = get_option('fg_allowed_roles', ['administrator']);

    $current_user = wp_get_current_user();
    if ( ! $current_user instanceof WP_User ) {
        return;
    }

    if ( empty(array_intersect($allowed_roles, $current_user->roles)) ) {
        remove_menu_page('edit.php?post_type=fg_gallery');
    }
}
add_action('admin_menu', 'fg_restrict_gallery_menu_access', 99);
