<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package dfw
 */

?>
<div class="bg-wrapper top-bg-wrapper inner-bg padding-top-bott mar-bott">
           
		   <div class="clearflx"></div>
		   <div class="bootstrap-wrapper">
		   <div class="container  padding-top-bott2">
			  <div class="row">
				<div class="col-md-12 inner-block">
				<h2><em></em><span><?php esc_html_e( 'Nothing Found', 'horticulture' ); ?></span></h2>
<section class="no-results not-found">
	
	<div class="page-content">
		<?php
		if ( is_home() && current_user_can( 'publish_posts' ) ) :

			printf(
				'<p>' . wp_kses(
					/* translators: 1: link to WP admin new post page. */
					__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'horticulture' ),
					array(
						'a' => array(
							'href' => array(),
						),
					)
				) . '</p>',
				esc_url( admin_url( 'post-new.php' ) )
			);

		elseif ( is_search() ) :
			?>

			<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'horticulture' ); ?></p>
			<?php
			get_search_form();

		else :
			?>

			<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'horticulture' ); ?></p>
			<?php
			get_search_form();

		endif;
		?>
	</div><!-- .page-content -->
</section><!-- .no-results -->
</div>
			  
			  </div>
		   </div></div>
		</div>	
