<?php
/**
 * Template Name: Whois Who Template
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package dfw
 */

 get_header();
 ?>
 <section class="wrapper banner-wrapper">
         <div id="flexSlider" class="flexslider">
            <div class="inner-banner">
               <div class="container">
                  <div class="innerbread">
				  <div class="breadcam txtcenter-white">

              <?php if (function_exists('custom_breadcrumbs')) custom_breadcrumbs(); ?>

				  
				  
				  
</div>
                      <!-- <h3 class="txtcenter-white"><?php $page_title = get_the_title(); echo strip_tags($page_title); ?></h3>
                      <div class="breadcam txtcenter-white">
                        <ul>
                           <li><a href="home.html">Home </a></li>
                           <li><a href="#">About Us</a></li>
                           <li class="current">Mission and Vision</li>
                        </ul>
                     </div> -->
   <!-- <p class="text-center breadcrumbs"><span class="mr-2"><a href="#">Home <i class="ion-ios-arrow-forward"></i></a></span></p> -->
                  </div>
                </div>
            </div>
         </div>
      </section> 
	  <div class="wrapper" id="skipCont"></div>
      <!--/#skipCont-->
      
      
      <?php
$taxonomy = 'member-type';
$parent_term = get_term_by('slug', 'dfw-staff', $taxonomy);




$manual_order = ['director', 'accounts-section', 'fw-establishment-section', 'issue-section'];

$sub_terms_unsorted = get_terms([
    'taxonomy' => $taxonomy,
    'parent' => $parent_term->term_id,
    'hide_empty' => false
]);

$slug_map = [];
foreach ($sub_terms_unsorted as $term) {
    $slug_map[$term->slug] = $term;
}

// Manually sorted + fallback for any remaining
$sub_terms = [];
foreach ($manual_order as $slug) {
    if (isset($slug_map[$slug])) {
        $sub_terms[] = $slug_map[$slug];
    }
}
foreach ($sub_terms_unsorted as $term) {
    if (!in_array($term, $sub_terms, true)) {
        $sub_terms[] = $term;
    }
}


?>

<section style="padding:20px 0px;">
    <div class="container">
        <div class="row mb-3">
            <!-- Filter Dropdown -->
            <div class="col-md-4">
                <select id="member-filter" class="form-control">
                    <option value="">All Sections</option>
                    <?php foreach ($sub_terms as $term): ?>
                        <option value="<?php echo esc_attr($term->slug); ?>">
                            <?php echo esc_html($term->name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <!-- Dynamic Title -->
        <h4 id="table-title" style="margin-bottom:15px;font-size: 150%;font-weight: 700;color: #bb6026;">
            All Sections
        </h4>
        </div>

        

        <!-- Table -->
        <table id="whoiswho-table" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th style="width:100px;">S. No.</th>
                    <th>Name</th>
                    <th>Designation</th>
                    <th style="display:none;">Category</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $args = [
                    'post_type' => 'member',
                    'posts_per_page' => -1,
                    'post_status' => 'publish',
                    'order' => 'ASC',
                    'tax_query' => [
                        [
                            'taxonomy' => $taxonomy,
                            'field' => 'slug',
                            'terms' => 'dfw-staff',
                            'include_children' => true,
                        ]
                    ]
                ];
                $mloop = new WP_Query($args);
                $count = 1;
                if ($mloop->have_posts()) :
                    while ($mloop->have_posts()) : $mloop->the_post();
                        $terms = wp_get_post_terms(get_the_ID(), $taxonomy);
                        $term_classes = '';
                        foreach ($terms as $term) {
                            $term_classes .= ' ' . esc_attr($term->slug);
                        }
                ?>
                    <tr class="member-row<?php echo $term_classes; ?>">
                        <td><?php echo $count++; ?></td>
                        <td><?php the_title(); ?></td>
                        <td><?php the_field('designation'); ?></td>
                        <td style="display:none;"><?php echo trim($term_classes); ?></td>
                    </tr>
                <?php endwhile; endif; wp_reset_postdata(); ?>
            </tbody>
        </table>
    </div>
</section>

 <?php
 get_footer();
