<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package DFW
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
      <meta name="keywords" content="Directorate of Family Welfare, DFW, Govt of Odisha">
      <meta name="description" content="Directorate of Family Welfare, DFW, Govt of Odisha">
      <meta name="author" content="National Informatic Center">
      <link rel="apple-touch-icon" href="<?php echo get_template_directory_uri();?>/assets/images/favicon/apple-touch-icon.png">
      <link rel="icon" href="<?php echo get_template_directory_uri();?>/assets/images/favicon/favicon.png">
      <title>Home | Directorate of Family Welfare, Govt of Odisha</title>
      <!-- Custom styles for this template -->
      <link href="<?php echo get_template_directory_uri();?>/assets/css/base-responsive.css" rel="stylesheet" media="all">
      <link href="<?php echo get_template_directory_uri();?>/assets/css/font.css" rel="stylesheet" media="all">
      <link href="<?php echo get_template_directory_uri();?>/assets/css/font-awesome.min.css" rel="stylesheet" media="all">
      <link href="<?php echo get_template_directory_uri();?>/assets/css/flexslider.css" rel="stylesheet" media="all">
      <link href="<?php echo get_template_directory_uri();?>/assets/css/megamenu.css" rel="stylesheet" media="all" />
      <!-- Theme styles for this template -->
      <link href="<?php echo get_template_directory_uri();?>/assets/css/site-responsive.css" rel="stylesheet" media="all">
      <link href="<?php echo get_template_directory_uri();?>/assets/css/bootstrap-grid.css" rel="stylesheet" type="text/css">
      <!-- <link href="<?php echo get_template_directory_uri();?>/assets/css/dataTables.bootstrap.min.css" rel="stylesheet" type="text/css"> -->
      <link href="<?php echo get_template_directory_uri();?>/assets/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css">
      
      
	<?php wp_head(); ?>
</head>
<div id="fb-root"></div>
      <header>
         <div class="region region-header-top">
            <div id="block-cmf-content-header-region-block" class="block block-cmf-content first last odd">
               <noscript class="no_scr">"JavaScript is a standard programming language that is included to provide interactive features, Kindly enable Javascript in your browser. For details visit help page"
               </noscript>
               <div class="wrapper common-wrapper">
                  <div class="container common-container four_content top-header">
                     <div class="common-left clearfix">
                        <ul>
                           <li class="gov-india"><span class="responsive_go_hindi" lang="hi"><a target="_blank" href="#" title="ଓଡିଶା ସରକାର" role="link">ଓଡିଶା ସରକାର </a></span><span class="li_eng responsive_go_eng"><a target="_blank" href="#" title="Government of Odisha" role="link">Government of Odisha</a></span></li>
                           <li class="ministry">
                              <a href="#" target="_blank" alt="Directorate of Family Welfare" title="Directorate of Family Welfare, External link that opens in new tab"><span class="responsive_minis_hi" lang="hi"></span></a>
                              <a href="#" target="_blank" alt="Directorate of Family Welfare" title="Directorate of Family Welfare, External link that opens in new tab"><span class="li_eng responsive_minis_eng"> </span></a>
                           </li>
                        </ul>
                     </div>
                     <div class="common-right clearfix">
                        <ul id="header-nav">
                          <li class="ico-skip cf"><a href="#skipCont" title=""><?php if (pll_current_language() == 'od'){ echo "ମୁଖ୍ୟ ବିଷୟ ଦର୍ଶନ";  }else { echo "Skip to Main Content";} ?></a></li>
                           <li class="ico-site-search cf">
                              <a href="javascript:void(0);" id="toggleSearch" title="Site Search">
                              <img class="top" src="<?php echo get_template_directory_uri();?>/assets/images/ico-site-search.png" alt="Site Search" /></a>
                              <div class="search-drop both-search">
                              
                                 <div class="find">
                                 <?php get_search_form(); ?>
                                    <div id="auto_suggesion"></div>
                                 </div>
                              </div>
                           </li>
                           <li class="ico-accessibility cf">
                              <a href="javascript:void(0);" id="toggleAccessibility" title="Accessibility Dropdown" role="link">
                              <img class="top" src="<?php echo get_template_directory_uri();?>/assets/images/ico-accessibility.png" alt="Accessibility Dropdown" />
                              </a>
                              <ul>
                              <li><a href="javascript:void(0);" class="increaseFont" title="Increase font size" id="btn-increase"><?php if (pll_current_language() == 'od'){ echo "ଅ";  }else { echo "A";} ?><sup>+</sup></a></li>
                  <li><a href="javascript:void(0);" class="resetFont" title="Reset font size" id="btn-orig"><?php if (pll_current_language() == 'od'){ echo "ଅ";  }else { echo "A";} ?></a></li>
                  <li><a href="javascript:void(0);" class="decreaseFont" title="Decrease font size" id="btn-decrease"><?php if (pll_current_language() == 'od'){ echo "ଅ";  }else { echo "A";} ?><sup>-</sup></a></li>
                                 
                     

                                 <li> <a href="javascript:void(0);" class="high-contrast dark" title="High Contrast" role="link">A</a> </li>
                                 <li> <a href="javascript:void(0);" class="high-contrast light" title="Normal Contrast" style="display: none;" role="link">A</a> </li>
                              </ul>
                           </li>
                           <li class="ico-social cf">
                              <a href="javascript:void(0);" id="toggleSocial" title="Social Medias">
                              <img class="top" src="<?php echo get_template_directory_uri();?>/assets/images/iconsocial.png" alt="Social Medias"></a>
                              <ul style="visibility: hidden;">
                                 <li><a target="_blank" title="External Link that opens in a new window" href="http://www.facebook.com/"><img alt="Facebook Page" src="<?php echo get_template_directory_uri();?>/assets/images/facebook-24.png"></a></li>
                                 <li><a target="_blank" title="External Link that opens in a new window" href="http://www.twitter.com/"><img alt="Twitter Page" src="<?php echo get_template_directory_uri();?>/assets/images/twitter-x-24.png"></a></li>
                                 <li><a target="_blank" title="External Link that opens in a new window" href="http://www.youtube.com/"><img alt="youtube Page" src="<?php echo get_template_directory_uri();?>/assets/images/ico-youtube.png"></a></li>
                              </ul>
                           </li>
                           
                           <li class="ico-social cf"><a href="dfw/screen-reader-access" title="Screenreader">
                              <img class="top" src="<?php echo get_template_directory_uri();?>/assets/images/screenreader.png" alt="Screenreader" /></a>
                           </li>
                           <li class="ico-sitemap cf"><a href="" title="Sitemap">
                              <img class="top" src="<?php echo get_template_directory_uri();?>/assets/images/ico-sitemap.png" alt="Sitemap" /></a>
                           </li>
                           <li class="colorchanger hindi cmf_lan d-hide">
								<?php if ( is_active_sidebar( 'lswitcher' ) ) : ?>									
									<?php dynamic_sidebar( 'lswitcher' ); ?>									
								<?php endif; ?>
							</li>
                           
                        </ul>
                     </div>
                  </div>
               </div>
            </div>
            <button id="scrollToTopBtn" title="Go to top"> &#8679;</button>
         </div>
         <!--Top-Header Section end-->
         <section class="wrapper header-wrapper">
            <div class="container common-container four_content header-container">
               <h1 class="logo">                 
                  <img class="national_emblem" src="<?php echo get_template_directory_uri();?>/assets/images/emblem-dark.png" alt="national emblem" >
                  <span class="department-title">
                     <em><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="Home" rel="home" class="header__logo" id="logo">
                          <span>ପରିବାର କଲ୍ୟାଣ ନିର୍ଦ୍ଦେଶାଳୟ</span></a></em>
                     <em>
                           <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="Home" rel="home" class="header__logo" id="logo">
                           <span>Directorate of Family Welfare </span>
                           <h6>Government of Odisha </h6>
                        </a>
                     </em>
                  </span>
               </h1>
               <div class="header-right clearfix">
                  <div class="right-content clearfix">
                           <?php					
									$member_args = array(
											'post_type' => 'member',
											'posts_per_page' => -1,
											'post_status' => 'publish',
											'order' => 'ASC',
									      'tax_query' => array(
                                                array(
                                                   'taxonomy' => 'member-type',
                                                   'field' => 'slug',
                                                   'terms' => 'cm'
                                                      ),
                                                         )
                                                   );
									$mloop = new WP_Query($member_args);
									if($mloop->have_posts()) {
										while($mloop->have_posts()) : $mloop->the_post();
										$profile_img = get_field('upload_photo');
									?>
                     <div class="float-element mt-5 "><strong><?php the_title(); ?></strong> <br>
                        <span><?php the_field('designation'); ?></span>
                     </div>
                      <div class="float-element mn-1">
                        <a class="sw-logo " target="_blank" href="#" title="<?php the_title(); ?>">
                           <img src="<?php echo $profile_img;?>" alt="<?php the_title(); ?>" />
                        </a>
                     </div>
                     <?php 
								endwhile; 
							}
							wp_reset_query();
							?>   
                  </div>
               </div>
            </div>
         </section>
         <!--/.header-wrapper-->
         <section class="wrapper megamenu-wraper">
   <h2 style="display: none;">Megamenu</h2>
   <div class="container common-container four_content">
      <p class="showhide"><em></em><em></em><em></em></p>
      
      <nav class="main-menu clearfix" id="main_menu">
         
    <?php
        wp_nav_menu(array(
            'theme_location' => 'main-menu',
            'menu_class' => 'nav-menu',
            'container' => false,
            'walker' => new Custom_Walker_Nav_Menu()
        ));
    ?>
</nav>  
   </div>
</section>

      </header>

   <body <?php body_class(); ?>>
<?php wp_body_open(); ?>
