<?php
/**
 * dfw functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package dfw
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}
 
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function dfw_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on dfw, use a find and replace
		* to change 'dfw' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'dfw', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	
	// add_filter ( 'nav_menu_css_class', 'nav_item_li', 10, 4 );

	// function nav_item_li ( $classes, $item, $args, $depth ){
	//   $classes[] = 'nav-item';
	//   return $classes;
	// }

	// add_filter ( 'nav_menu_css_class', 'current_class_active', 10, 2 );

	// function current_class_active ( $classes, $item, $args, $depth ){
	// 	if (in_array('current-menu-item' , $classes)){

	// 		$classes[] = 'nav-item';
	// 	}
	  
	//   return $classes;
	// }
	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'dfw_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);
	

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );


	function custom_login_logo() {
		echo '<style type="text/css">
			#login h1 a, .login h1 a {
				background-image: url(' . get_stylesheet_directory_uri() . '/assets/images/emblem-dark.png);
				height: 100px; /* Change the height as needed */
				width: 100%; /* Use 100% width for responsiveness */
				background-size: contain; /* Adjust this property as needed */
			}
		</style>';
		
	}
	
	add_action('login_enqueue_scripts', 'custom_login_logo');
	
	function custom_login_logo_url() {
		return home_url();  // Replace this with any custom URL if needed
	}
	add_filter('login_headerurl', 'custom_login_logo_url');
	

	function custom_login_title() {
		return 'Directorate of Family Welfare, Govt of Odisha';
	}
	add_filter('login_headertext', 'custom_login_title');
	
	// Disabling XML-RPC can prevent attackers from exploiting potential vulnerabilities.
	add_filter('xmlrpc_enabled', '__return_false');


	 // Remove WordPress version number from the header and RSS feeds
	 function remove_wordpress_version_number() {
    	return '';
	}
	add_filter('the_generator', 'remove_wordpress_version_number');

	// Remove WordPress version number from scripts and styles
	function remove_wordpress_version_from_scripts($src) {
    if (strpos($src, 'ver=')) {
        $src = remove_query_arg('ver', $src);
    }
    return $src;
	}
	add_filter('style_loader_src', 'remove_wordpress_version_from_scripts', 9999);
	add_filter('script_loader_src', 'remove_wordpress_version_from_scripts', 9999);

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'dfw_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function dfw_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'dfw_content_width', 640 );
}
add_action( 'after_setup_theme', 'dfw_content_width', 0 );

function login_case_sensitive( $user, $username, $password ) {
    $user_id = username_exists($username);
    if( !$user_id ) {
        return $user;
    }
    $user_obj = get_user_by('id', $user_id);
    if( $username !== $user_obj->user_login ) {
        return new WP_Error( 'authentication_failed', __( '<strong>ERROR</strong>: Invalid username or password.' ) );
    }
    return $user;
}
add_filter( 'authenticate', 'login_case_sensitive', 20, 3 );

// Function to validate username and password during login
function validate_username_and_password($user, $username, $password) {
    $min_user_length = 4;  // Minimum length for username
    $max_user_length = 20; // Maximum length for username
    $min_pass_length = 8;  // Minimum length for password

    // Validate username length
    if (strlen($username) < $min_user_length) {
        return new WP_Error('invalid_username', sprintf(__('⚠ Username must be at least %d characters long.'), $min_user_length));
    }

    if (strlen($username) > $max_user_length) {
        return new WP_Error('invalid_username', sprintf(__('⚠ Username cannot be longer than %d characters.'), $max_user_length));
    }

    // Validate password
    if (empty($password)) {
        return new WP_Error('empty_password', __('⚠ Password cannot be empty.'));
    }

    if (strlen($password) < $min_pass_length) {
        return new WP_Error('short_password', sprintf(__('⚠ Password must be at least %d characters long.'), $min_pass_length));
    }

    return $user;
}
add_filter('authenticate', 'validate_username_and_password', 30, 3);


function custom_login_inline_username_length_check() {
    if (in_array($GLOBALS['pagenow'], ['wp-login.php'])) {
        ?>
        <style>
            .error-message {
                color: red;
                font-size: 13px;
                margin-top: 5px;
                display: none;
            }
        </style>
        <script type="text/javascript">
            document.addEventListener('DOMContentLoaded', function () {
                var usernameField = document.getElementById('user_login');
                var passwordField = document.getElementById('user_pass');

                // Username error message
                var usernameErrorDiv = document.createElement('div');
                usernameErrorDiv.id = 'username-error';
                usernameErrorDiv.className = 'error-message';
                usernameField.parentNode.appendChild(usernameErrorDiv);

                // Password error message
                var passwordErrorDiv = document.createElement('div');
                passwordErrorDiv.id = 'password-error';
                passwordErrorDiv.className = 'error-message';
                passwordField.parentNode.appendChild(passwordErrorDiv);

                var minUsernameLength = 4;
                var maxUsernameLength = 20;
                var minPasswordLength = 8;

                // Validate username on password field focus
                passwordField.addEventListener('focus', function () {
                    var username = usernameField.value.trim();
                    var usernameError = '';

                    if (username.length < minUsernameLength) {
                        usernameError = '⚠ Username must be at least ' + minUsernameLength + ' characters long.';
                    } else if (username.length > maxUsernameLength) {
                        usernameError = '⚠ Username cannot be longer than ' + maxUsernameLength + ' characters.';
                    }

                    if (usernameError !== '') {
                        usernameErrorDiv.textContent = usernameError;
                        usernameErrorDiv.style.display = 'block';
                        usernameField.focus();
                    } else {
                        usernameErrorDiv.textContent = '';
                        usernameErrorDiv.style.display = 'none';
                    }
                });

                // Validate on form submit
                var loginForm = document.getElementById('loginform');
                loginForm.addEventListener('submit', function (e) {
                    var password = passwordField.value.trim();
                    var passwordError = '';

                    if (password === '') {
                        passwordError = '⚠ Password cannot be empty.';
                    } else if (password.length < minPasswordLength) {
                        passwordError = '⚠ Password must be at least ' + minPasswordLength + ' characters long.';
                    }

                    if (passwordError !== '') {
                        e.preventDefault();
                        passwordErrorDiv.textContent = passwordError;
                        passwordErrorDiv.style.display = 'block';
                        passwordField.focus();
                    } else {
                        passwordErrorDiv.textContent = '';
                        passwordErrorDiv.style.display = 'none';
                    }
                });

                // Hide error message when typing
                usernameField.addEventListener('input', function () {
                    usernameErrorDiv.textContent = '';
                    usernameErrorDiv.style.display = 'none';
                });

                passwordField.addEventListener('input', function () {
                    passwordErrorDiv.textContent = '';
                    passwordErrorDiv.style.display = 'none';
                });
            });
        </script>
        <?php
    }
}
add_action('login_enqueue_scripts', 'custom_login_inline_username_length_check');


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function dfw_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'dfw' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'dfw' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar( 
		array(
			'name'          => __( 'Language switcher', 'dfw' ),
			'id'            => 'lswitcher',
			'description'   => __( 'Add Language widgets here', 'dfw' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '',
			'after_title'   => '',
	) );
	register_sidebar( 
		array(
			'name'          => __( 'Footer1', 'dfw' ),
			'id'            => 'Footer1',
			'description'   => __( 'Add Footer1 widgets here', 'dfw' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
	) );
	register_sidebar( 
		array(
			'name'          => __( 'Footer2', 'dfw' ),
			'id'            => 'Footer2',
			'description'   => __( 'Add Footer2 widgets here', 'dfw' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
	) );
	register_sidebar( 
		array(
			'name'          => __( 'Footer3', 'dfw' ),
			'id'            => 'Footer3',
			'description'   => __( 'Add Footer3 widgets here', 'dfw' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
	) );
	register_sidebar( 
		array(
			'name'          => __( 'Footer4', 'dfw' ),
			'id'            => 'Footer4',
			'description'   => __( 'Add Footer4 widgets here', 'dfw' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
	) );
	register_sidebar( 
		array(
			'name'          => __( 'Disclaimer', 'dfw' ),
			'id'            => 'Disclaimer',
			'description'   => __( 'Add Disclaimer widgets here', 'dfw' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
	) );
	register_sidebar( 
		array(
			'name'          => __( 'Total visitors', 'dfw' ),
			'id'            => 'Total visitors',
			'description'   => __( 'Add Total visitors widgets here', 'dfw' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'dfw_widgets_init' );
function custom_post_type() {
	$member_labels = array(
			'name'                => _x( 'Member', 'Post Type General Name', 'dfw' ),
			'singular_name'       => _x( 'Member', 'Post Type Singular Name', 'dfw' ),
			'menu_name'           => __( 'Member', 'dfw' ),
			'parent_item_colon'   => __( 'Parent Member', 'dfw' ),
			'all_items'           => __( 'All Member', 'dfw' ),
			'view_item'           => __( 'View Member', 'dfw' ),
			'add_new_item'        => __( 'Add New Member', 'dfw' ),
			'add_new'             => __( 'Add Member', 'dfw' ),
			'edit_item'           => __( 'Edit Member', 'dfw' ),
			'update_item'         => __( 'Update Member', 'dfw' ),
			'search_items'        => __( 'Search Member', 'dfw' ),
			'not_found'           => __( 'Not Found', 'dfw' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'dfw' ),
		);
		 
		$member_args = array(
			'label'               => __( 'Member', 'dfw' ),
			'description'         => __( 'Member', 'dfw' ),
			'labels'              => $member_labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'page-attributes', 'revisions', ),
			'hierarchical'        => false,
			'public'              => true,
			'menu_icon'           => 'dashicons-buddicons-buddypress-logo',

			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 5,
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'page',
		);
		register_post_type( 'member', $member_args );

		$newsevent_labels = array(
			'name'                => _x( 'News Event', 'Post Type General Name', 'dfw' ),
			'singular_name'       => _x( 'News Event', 'Post Type Singular Name', 'dfw' ),
			'menu_name'           => __( 'News Event', 'dfw' ),
			'parent_item_colon'   => __( 'Parent News Event', 'dfw' ),
			'all_items'           => __( 'All News Event', 'dfw' ),
			'view_item'           => __( 'View News Event', 'dfw' ),
			'add_new_item'        => __( 'Add New News Event', 'dfw' ),
			'add_new'             => __( 'Add News Event', 'dfw' ),
			'edit_item'           => __( 'Edit News Event', 'dfw' ),
			'update_item'         => __( 'Update News Event', 'dfw' ),
			'search_items'        => __( 'Search News Event', 'dfw' ),
			'not_found'           => __( 'Not Found', 'dfw' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'dfw' ),
		);
		 
		$newsevent_args = array(
			'label'               => __( 'News Event', 'dfw' ),
			'description'         => __( 'News Event', 'dfw' ),
			'labels'              => $newsevent_labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'page-attributes', 'revisions', ),
			'menu_icon'           => 'dashicons-welcome-widgets-menus',
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 5,
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'page',
		);
		register_post_type( 'News Event', $newsevent_args );

		$slider_labels = array(
			'name'                => _x( 'Slider', 'Post Type General Name', 'dfw' ),
			'singular_name'       => _x( 'Slider', 'Post Type Singular Name', 'dfw' ),
			'menu_name'           => __( 'Slider', 'dfw' ),
			'parent_item_colon'   => __( 'Parent Slider', 'dfw' ),
			'all_items'           => __( 'All Slider', 'dfw' ),
			'view_item'           => __( 'View Slider', 'dfw' ),
			'add_new_item'        => __( 'Add New Slider', 'dfw' ),
			'add_new'             => __( 'Add Slider', 'dfw' ),
			'edit_item'           => __( 'Edit Slider', 'dfw' ),
			'update_item'         => __( 'Update Slider', 'dfw' ),
			'search_items'        => __( 'Search Slider', 'dfw' ),
			'not_found'           => __( 'Not Found', 'dfw' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'dfw' ),
		);
		 
		$slider_args = array(
			'label'               => __( 'Slider', 'dfw' ),
			'description'         => __( 'Slider', 'dfw' ),
			'labels'              => $slider_labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'page-attributes', 'revisions', ),
			'menu_icon'           => 'dashicons-cover-image',
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 5,
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'page',
		);
		register_post_type( 'Slider', $slider_args );


		
	
	$latestupdate_labels = array(
        'name'                => _x( 'Latest Update', 'Post Type General Name', 'dfw' ),
        'singular_name'       => _x( 'Latest Update', 'Post Type Singular Name', 'dfw' ),
        'menu_name'           => __( 'Latest Update', 'dfw' ),
        'parent_item_colon'   => __( 'Parent Latest Update', 'dfw' ),
        'all_items'           => __( 'All Latest Update', 'dfw' ),
        'view_item'           => __( 'View Latest Update', 'dfw' ),
        'add_new_item'        => __( 'Add New Latest Update', 'dfw' ),
        'add_new'             => __( 'Add Latest Update', 'dfw' ),
        'edit_item'           => __( 'Edit Latest Update', 'dfw' ),
        'update_item'         => __( 'Update Latest Update', 'dfw' ),
        'search_items'        => __( 'Search Latest Update', 'dfw' ),
        'not_found'           => __( 'Not Found', 'dfw' ),
        'not_found_in_trash'  => __( 'Not found in Trash', 'dfw' ),
    );
     
    $latestupdate_args = array(
        'label'               => __( 'Latest Update', 'dfw' ),
        'description'         => __( 'Latest Update', 'dfw' ),
        'labels'              => $latestupdate_labels,
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'page-attributes', 'revisions', ),
        'hierarchical'        => false,
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_nav_menus'   => true,
        'show_in_admin_bar'   => true,
        'menu_position'       => 7,
        'can_export'          => true,
        'has_archive'         => true,
        'exclude_from_search' => false,
        'publicly_queryable'  => true,
        'capability_type'     => 'page',
    );
    register_post_type( 'latestupdate', $latestupdate_args );
		
	}
	add_action( 'init', 'custom_post_type', 0 );
    add_action( 'init', 'create_my_taxonomies', 0 );
    function create_my_taxonomies() {

		register_taxonomy(
			'member-type',
			array('member'),
			array(
				'labels' => array(
					'name' => 'Member Type',
					'add_new_item' => 'Add New Member Type',
					'new_item_name' => "New Member Type"
				),
				'show_ui' => true,
				'show_tagcloud' => false,
				'hierarchical' => true
			)
		);
		register_taxonomy(
			'newsevent-type',
			array('newsevent'),
			array(
				'labels' => array(
					'name' => 'newsevent Type',
					'add_new_item' => 'Add New newsevent Type',
					'new_item_name' => "New newsevent Type"
				),
				'show_ui' => true,
				'show_tagcloud' => false,
				'hierarchical' => true
			)
		);
		register_taxonomy(
			'slider_area',
			array('slider'),
			array(
				'labels' => array(
					'name' => 'Slider Area',
					'add_new_item' => 'Add New Slider Area',
					'new_item_name' => "New Slider Area"
				),
				'show_ui' => true,
				'show_tagcloud' => false,
				'hierarchical' => true
			)
		);
		
		register_taxonomy(
			'latest_update',
			array('latestupdate'),
			array(
				'labels' => array(
					'name' => 'Latest Update Category',
					'add_new_item' => 'Add New Latest Update Category',
					'new_item_name' => "New Latest Update Category"
				),
				'show_ui' => true,
				'show_tagcloud' => false,
				'hierarchical' => true
			)
		);
	}

/**
 * Breadcrumb.
 */	
function custom_breadcrumbs() {
    // Settings
    $separator          = ''; // Separator icon or text, e.g., '&gt;'
    $home_title         = 'Home'; // Text for the "Home" link

    // If you want to use a different separator
    // $separator = '<span class="separator"> &gt; </span>';

    // Get the query & post information
    global $post;

    // Do not display on the homepage
    if (!is_front_page()) {
        
        // Build the breadcrumbs
        echo '<ul class="breadcrumbs">';

        // Home page
        echo '<li class="item-home"><a class="bread-link bread-home" href="' . get_home_url() . '" title="' . $home_title . '">' . $home_title . '</a></li>';

        if (is_archive() && !is_tax() && !is_category() && !is_tag()) {
            echo '<li class="item-current item-archive"><strong class="bread-current bread-archive">' . post_type_archive_title($prefix, false) . '</strong></li>';
        } elseif (is_archive() && is_tax() && !is_category() && !is_tag()) {
            // Custom Taxonomies
            $post_type = get_post_type();

            if ($post_type != 'post') {
                $post_type_object = get_post_type_object($post_type);
                $post_type_archive = get_post_type_archive_link($post_type);

                echo '<li class="item-cat item-custom-post-type-' . $post_type . '"><a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a></li>';
                echo '<li class="separator"> ' . $separator . ' </li>';
            }

            $custom_tax_name = get_queried_object()->name;
            echo '<li class="item-current item-archive"><strong class="bread-current bread-archive">' . $custom_tax_name . '</strong></li>';

        } elseif (is_single()) {
            // Single Post
            $category = get_the_category();
            if (!empty($category)) {
                $last_category = end(array_values($category));
                $get_cat_parents = rtrim(get_category_parents($last_category->term_id, true, ','), ',');
                $cat_parents = explode(',', $get_cat_parents);

                foreach ($cat_parents as $parent) {
                    echo '<li class="item-cat">' . $parent . '</li>';
                }
                echo '<li class="separator"> ' . $separator . ' </li>';
            }

            echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong></li>';
        } elseif (is_category()) {
            // Category Page
            echo '<li class="item-current item-cat"><strong class="bread-current bread-cat">' . single_cat_title('', false) . '</strong></li>';
        } elseif (is_page()) {
            // Standard Page
            if ($post->post_parent) {
                $anc = get_post_ancestors($post->ID);
                $anc = array_reverse($anc);

                foreach ($anc as $ancestor) {
                    echo '<li class="item-parent item-parent-' . $ancestor . '"><a class="bread-parent bread-parent-' . $ancestor . '" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '">' . get_the_title($ancestor) . '</a></li>';
                    echo '<li class="separator separator-' . $ancestor . '"> ' . $separator . ' </li>';
                }
            }
            echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong></li>';
        } elseif (is_tag()) {
            // Tag Page
            echo '<li class="item-current item-tag"><strong class="bread-current bread-tag">' . single_tag_title('', false) . '</strong></li>';
        } elseif (is_day()) {
            // Day Archive
            echo '<li class="item-year item-year-' . get_the_time('Y') . '"><a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link(get_the_time('Y')) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . '</a></li>';
            echo '<li class="separator separator-' . get_the_time('Y') . '"> ' . $separator . ' </li>';
            echo '<li class="item-month item-month-' . get_the_time('m') . '"><a class="bread-month bread-month-' . get_the_time('m') . '" href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . '</a></li>';
            echo '<li class="separator separator-' . get_the_time('m') . '"> ' . $separator . ' </li>';
            echo '<li class="item-current item-' . get_the_time('j') . '"><strong class="bread-current bread-' . get_the_time('j') . '" title="' . get_the_time('j') . '">' . get_the_time('j') . '</strong></li>';
        } elseif (is_month()) {
            // Month Archive
            echo '<li class="item-year item-year-' . get_the_time('Y') . '"><a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link(get_the_time('Y')) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . '</a></li>';
            echo '<li class="separator separator-' . get_the_time('Y') . '"> ' . $separator . ' </li>';
            echo '<li class="item-current item-month-' . get_the_time('m') . '"><strong class="bread-current bread-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . '</strong></li>';
        } elseif (is_year()) {
            // Year Archive
            echo '<li class="item-current item-current-' . get_the_time('Y') . '"><strong class="bread-current bread-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . '</strong></li>';
        } elseif (is_author()) {
            // Author Archive
            global $author;
            $userdata = get_userdata($author);
            echo '<li class="item-current item-current-' . $userdata->user_nicename . '"><strong class="bread-current bread-current-' . $userdata->user_nicename . '" title="' . $userdata->display_name . '">' . 'Author: ' . $userdata->display_name . '</strong></li>';
        } elseif (get_query_var('paged')) {
            // Paginated Archives
            echo '<li class="item-current item-current-' . get_query_var('paged') . '"><strong class="bread-current bread-current-' . get_query_var('paged') . '" title="Page ' . get_query_var('paged') . '">' . __('Page') . ' ' . get_query_var('paged') . '</strong></li>';
        } elseif (is_search()) {
            // Search Results Page
            echo '<li class="item-current item-current-search"><strong class="bread-current bread-current-search" title="Search results for: ' . get_search_query() . '">Search results for: ' . get_search_query() . '</strong></li>';
        } elseif (is_404()) {
            // 404 Page
            echo '<li>' . 'Error 404' . '</li>';
        }

        echo '</ul>';
    }
}

 


// Custom Breadcrumb one
// function get_breadcrumb() {
//     echo '<a href="'.home_url().'" rel="nofollow">Home</a>';
//     if (is_category() || is_single()) {
//         echo "&nbsp;&nbsp;&#187;&nbsp;&nbsp;";
//         the_category(' &bull; ');
//             if (is_single()) {
//                 echo " &nbsp;&nbsp;&#187;&nbsp;&nbsp; ";
//                 the_title();
//             }
//     } elseif (is_page()) {
//         echo "&nbsp;&nbsp;&#187;&nbsp;&nbsp;";
//         echo the_title();
//     } elseif (is_search()) {
//         echo "&nbsp;&nbsp;&#187;&nbsp;&nbsp;Search Results for... ";
//         echo '"<em>';
//         echo the_search_query();
//         echo '</em>"';
//     }
// }


// Custom Breadcrumb two
// function custom_breadcrumb() {
// 	global $post;
// 	if ( ! is_home() ) {
// 		echo '<a href="' . site_url() . '">Home</a> / ';
// 		if ( is_category() || is_single() ) {
// 			the_category( ' / ' );
// 			if ( is_single() ) {
// 				echo ' / ';
// 				the_title();
// 			}
// 		} elseif ( is_page() ) {
// 			if ( $post->post_parent ) {
// 				$anc   = get_post_ancestors( $post->ID );
// 				$title = get_the_title();
// 				foreach ( $anc as $ancestor ) {
// 					$output = '<a href="' . get_permalink( $ancestor ) . '" title="' . get_the_title( $ancestor ) . '">' . get_the_title( $ancestor ) . '</a> / ';
// 				}
// 				echo $output;
// 				echo $title;
// 			} else {
// 				echo '<strong> ' . get_the_title() . '</strong>';
// 			}
// 		}
// 	}
// }
/**
 * Enqueue scripts and styles.
 */
function dfw_scripts() {
	wp_enqueue_style( 'dfw-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'dfw-style', 'rtl', 'replace' );

	wp_enqueue_script( 'dfw-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'dfw_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * start dynamic menu for wordpress.
 */
function register_custom_menus() {
    register_nav_menu('main-menu', __('Main Menu'));
}
add_action('init', 'register_custom_menus');


class Custom_Walker_Nav_Menu extends Walker_Nav_Menu {
    function start_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<div class=\"sub-nav col-1\">\n<ul class=\"sub-nav-group\">\n";
    }

    function end_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "$indent</ul>\n</div>\n";
    }

    function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
        $indent = ($depth) ? str_repeat("\t", $depth) : '';

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $classes = array_filter($classes, function($class) {
            return !in_array($class, ['menu-item-type-post_type', 'menu-item-object-page']);
        });

        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item));

        $output .= $indent . '<li' . (!empty($class_names) ? ' class="' . esc_attr($class_names) . '"' : '') . '>';

        $attributes  = ' class="' . ($depth === 0 && strtolower($item->title) === 'home' ? 'home' : '') . '"';
        $attributes .= !empty($item->attr_title) ? ' title="' . esc_attr($item->attr_title) . '"' : '';
        $attributes .= !empty($item->url) ? ' href="' . esc_url($item->url) . '"' : '';

        $title = apply_filters('the_title', $item->title, $item->ID);

        if ($depth === 0 && strtolower($item->title) === 'home') {
            $item_output = '<a' . $attributes . '><span>' . $title . '</span><i class="fa fa-home"></i></a>';
        } else {
            $item_output = '<a' . $attributes . '>' . $title . '</a>';
        }

        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }

    function end_el( &$output, $item, $depth = 0, $args = array() ) {
        $output .= "</li>\n";
    }
}
/**
 * dynamic total_visitors add shotcode-[total_visitors]for wordpress.
 */
function track_total_visitors_only() {
    $file = ABSPATH . 'wp-content/total_visitors.txt';

    // Get current count
    $count = (file_exists($file)) ? (int) file_get_contents($file) : 0;

    // Increment count
    $count++;

    // Save updated count
    file_put_contents($file, $count);
}
add_action('init', 'track_total_visitors_only');
function show_total_visitors_only() {
    $file = ABSPATH . 'wp-content/total_visitors.txt';
    $count = (file_exists($file)) ? (int) file_get_contents($file) : 0;

    ob_start(); ?>
    <div class="total-visitor-box">
        Total Visitors: <strong><?php echo $count; ?></strong>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('total_visitors', 'show_total_visitors_only');

//disable autocomplete
add_action('login_enqueue_scripts', 'acme_disable_autocomplete_on_login');
function acme_disable_autocomplete_on_login() {
    ?>
    <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function () {
            const loginForm = document.getElementById('loginform');
            if (loginForm) {
                loginForm.setAttribute('autocomplete', 'off');

                const inputs = loginForm.querySelectorAll('input');
                inputs.forEach(input => input.setAttribute('autocomplete', 'off'));
            }
        });
    </script>
    <?php
}

//Validation from Start and End date 
add_action('acf/validate_save_post', 'my_acf_validate_save_post', 10, 0);
function my_acf_validate_save_post() {
    $start_key = 'field_6846ed53f8d7c'; // Start Date
    $end_key   = 'field_6846ee23f8d7d'; // End Date

    if (isset($_POST['acf'][$start_key]) && isset($_POST['acf'][$end_key])) {
        $start_raw = $_POST['acf'][$start_key]; // Format: Ymd
        $end_raw   = $_POST['acf'][$end_key];

        $start = DateTime::createFromFormat('Ymd', $start_raw);
        $end   = DateTime::createFromFormat('Ymd', $end_raw);

        if ($start && $end && $start > $end) {
            // Global error message
            acf_add_validation_error('', '⚠ End Date should be greater than or equal to Start Date');

            // Field highlight — try both key and name (only one will match)
            acf_add_validation_error('end_date', '');
            acf_add_validation_error('field_6846ee23f8d7d', '');
        }
    }
}

// to disable cut, copy, and paste on the login fields
	function disable_copy_paste_login_fields() {
		?>
		<script>
		jQuery(document).ready(function($){
			$('#user_login, #user_pass').on('cut copy paste', function(e) {
				e.preventDefault();
			});

			// Optional: disable right-click
			$('#user_login, #user_pass').on('contextmenu', function(e) {
				e.preventDefault();
			});
		});
		</script>
		<?php
	}
	add_action('login_footer', 'disable_copy_paste_login_fields');
