jQuery(document).ready(function(){
	var $affectedElements = jQuery("p,body,a"); // Can be extended, ex. $("div, p, span.someClass")
		// Storing the original size in a data attribute so size can be reset
		$affectedElements.each( function(){
		  var $this = jQuery(this);
		  $this.data("orig-size", $this.css("font-size") );
		});

		jQuery("#btn-increase").click(function(){
		  changeFontSize(1);
		})

		jQuery("#btn-decrease").click(function(){
		  changeFontSize(-1);
		})

		jQuery("#btn-orig").click(function(){
		  $affectedElements.each( function(){
				var $this = jQuery(this);
				$this.css( "font-size" , $this.data("orig-size") );
		   });
		});

		function changeFontSize(direction){
			$affectedElements.each( function(){
				var $this = jQuery(this);
				$this.css( "font-size" , parseInt($this.css("font-size"))+direction );
			});
		}
});