// ✅ jQuery-safe wrapper
jQuery(function ($) {
  // === FlexSliders - load after window is fully ready
  $(window).on("load", function () {
    // Flexslider Examples
    $('#flexSlider, #flexSlider1, #flexSlider2').flexslider({
      animation: "slide",
      controlNav: true,
      pausePlay: true,
      start: function () {
        $('body').removeClass('loading');
      }
    });

    $('#contSlider1').flexslider({
      animation: "swing",
      direction: "vertical",
      controlNav: false,
      directionNav: false,
      easing: 'linear',
      slideshowSpeed: 1000,
      animationSpeed: 10000,
      pausePlay: true,
      pauseOnHover: true,
      minItems: 2,
      maxItems: 2,
      move: 2
    });

    $('#contSlider2').flexslider({
      animation: "slide",
      controlNav: false
    });

    $('#flexCarousel').flexslider({
      animation: "slide",
      animationLoop: false,
      itemWidth: 200,
      itemMargin: 5,
      minItems: 2,
      maxItems: 6,
      slideshow: 1,
      move: 1,
      controlNav: false
    });

    $('#breaking_news').flexslider({
      animation: "slide",
      controlNav: false,
      animationLoop: true,
      direction: "horizontal",
      slideshowSpeed: 7000,
      animationSpeed: 600,
      pausePlay: true,
      pauseText: '',
      playText: '',
      pauseOnHover: false
    });

    $('#galleryCarousel').flexslider({
      animation: "fade",
      controlNav: "thumbnails"
    });
  });

  // === Tabs
  $('#parentHorizontalTab1, #parentHorizontalTab, #parentHorizontalTab2').easyResponsiveTabs({
    type: 'default',
    width: 'auto',
    fit: true,
    tabidentify: 'hor_1',
    activate: function (event) {
      $('#nested-tabInfo span').text($(this).text());
      $('#nested-tabInfo').show();
    }
  });

  $('#ChildVerticalTab_1').easyResponsiveTabs({
    type: 'vertical',
    width: 'auto',
    fit: true,
    tabidentify: 'ver_1',
    activetab_bg: '#fff',
    inactive_bg: '#fff',
    active_border_color: '#c1c1c1',
    active_content_border_color: '#5AB1D0'
  });

  // === Scroll to Top Button
  $(window).on('scroll', function () {
    const btn = $("#scrollToTopBtn");
    if ($(this).scrollTop() > 100) {
      btn.fadeIn().css("display", "flex");
    } else {
      btn.fadeOut();
    }
  });

  $("#scrollToTopBtn").on("click", function () {
    $("html, body").animate({ scrollTop: 0 }, "smooth");
  });

  // === Horizontal Tab Scroll Text Toggle
  window.changeClass = function () {
    $(".text-slide").toggleClass("pause");
    $(".scroll-text").toggleClass("scroll-left");
  };
  window.changeClass1 = function () {
    $(".text-slide1").toggleClass("pause");
    $(".scroll-text-1").toggleClass("scroll-left");
  };

  // === Counter Animation
  let counterTriggered = false;
  $(window).on("scroll", function () {
    const oTop = $('#counter').offset()?.top - window.innerHeight;
    if (!counterTriggered && $(window).scrollTop() > oTop) {
      $('.count').each(function () {
        $(this).prop('Counter', 0).animate({
          Counter: $(this).text()
        }, {
          duration: 4000,
          easing: 'swing',
          step: function (now) {
            $(this).text(Math.ceil(now));
          }
        });
      });
      counterTriggered = true;
    }
  });

  // === Gallery Init
  $('figure img').ma5gallery({ preload: true });

  // === Dropdown Filter (Who's Who)
  $('#member-filter').on('change', function () {
    const selected = $(this).val();
    $('#example tbody tr').each(function () {
      if (!selected || $(this).hasClass(selected)) {
        $(this).show();
      } else {
        $(this).hide();
      }
    });
  });

  $('#member-filter').on('change', function () {
    const selectedText = $(this).find("option:selected").text();
    $('#table-title').text($(this).val() ? selectedText : "All Sections");
  });

  // === Read more button (if exists)
  $('#read-more-btn').on('click', function () {
    $('.hidden-update').css('display', 'list-item');
    $(this).hide();
  });

  // === Tab switching (generic content)
  $(".tab-link").on("click", function (e) {
    e.preventDefault();
    const target = $(this).attr("href");

    $(".tab-link").removeClass("active");
    $(".tab-content").removeClass("active").css("animation", "none");

    $(this).addClass("active");
    $(target).addClass("active").css("animation", "fadeIn 0.4s ease");
  });

  // === Inline SVG interaction (map)
  $("#svg-container").load("svg/fondcarte-collec_actuelle.svg", function () {
    $("#chat_orissa path, #chat_orissa circle").on("click", function () {
      $("#chat_orissa path").removeAttr("style");
      const bbox = this.getBBox();
      const cx = bbox.x + bbox.width / 2;
      const cy = bbox.y + bbox.height / 2;
      $(this).css({
        "transform-origin": `${cx}px ${cy}px`,
        "transform": "scale(1.1)",
        "stroke": "white",
        "fill": "green"
      });
      this.parentElement.appendChild(this); // bring to front
    });
  });

  // === Video overlay play button
  const videoWrapper = document.querySelector('.video-wrapper');
  const video = document.querySelector('video');
  if (videoWrapper && video) {
    videoWrapper.insertAdjacentHTML('beforeend',
      `<svg class="video-overlay-play-button" viewBox="0 0 200 200" alt="Play video">
        <circle cx="100" cy="100" r="90" fill="none" stroke-width="15" stroke="#fff"/>
        <polygon points="70, 55 70, 145 145, 100" fill="#fff"/>
      </svg>`
    );
    const playBtn = document.querySelector('.video-overlay-play-button');
    video.classList.add('has-media-controls-hidden');
    playBtn.addEventListener('click', () => {
      video.play();
      playBtn.classList.add('is-hidden');
      video.classList.remove('has-media-controls-hidden');
      video.setAttribute('controls', 'controls');
    });
  }
});
