<?php
/**
 * Template Name: Tender Template
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package dfw
 */

 get_header();
 ?>
 <section class="wrapper banner-wrapper">
         <div id="flexSlider" class="flexslider">
            <div class="inner-banner">
               <div class="container">
                  <div class="innerbread">
				  <div class="breadcam txtcenter-white">

              <?php if (function_exists('custom_breadcrumbs')) custom_breadcrumbs(); ?>

				  
				  
				  
</div>
                      <!-- <h3 class="txtcenter-white"><?php $page_title = get_the_title(); echo strip_tags($page_title); ?></h3>
                      <div class="breadcam txtcenter-white">
                        <ul>
                           <li><a href="home.html">Home </a></li>
                           <li><a href="#">About Us</a></li>
                           <li class="current">Mission and Vision</li>
                        </ul>
                     </div> -->
   <!-- <p class="text-center breadcrumbs"><span class="mr-2"><a href="#">Home <i class="ion-ios-arrow-forward"></i></a></span></p> -->
                  </div>
                </div>
            </div>
         </div>
      </section> 
	  <div class="wrapper" id="skipCont"></div>
      <!--/#skipCont-->
 <?php
// Get today's date for PHP comparison
$today = date('Y-m-d');
?>

<section style="padding:20px 0px;">
    <div class="container">
        

        <div class="row mb-3">
            <div class="tender-filters">
    <div class="filter-group">
        <label for="tender-filter">Filter:</label>
        <select id="tender-filter" class="form-control">
            <option value="open" selected>Open Tenders</option>
            <option value="closed">Closed Tenders</option>
            <option value="all">All Tenders</option>
        </select>
    </div>
    <div class="filter-group">
        <label for="min-date">From Date:</label>
        <input type="date" id="min-date" class="form-control" />
    </div>
    <div class="filter-group">
        <label for="max-date">To Date:</label>
        <input type="date" id="max-date" class="form-control" />
    </div>
</div>

        </div>
        <div class="row">
            <table id="tenders-table" class="display" style="width:100%;">
                <thead>
                    <tr>
                        <th>S. No.</th>
                        <th>Title</th>
                        <th>Start Date</th>
                        <th>Closing Date</th>
                        <th>Download</th>
                    </tr>
                </thead>
                <tbody>
                <?php 
                    $tender_args = array( 
                        'post_type'=> 'latestupdate', 
                        'posts_per_page' => -1,
                        'post_status' => 'publish',
                        'order' => 'DESC',
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'latest_update',
                                'field'    => 'slug',
                                'terms'    => 'tenders',
                            ),
                        ),
                    );      

                    $loop = new WP_Query($tender_args);
                    $count = 1;

                    if($loop->have_posts()) :
                        while($loop->have_posts()) : $loop->the_post();
                            $start_date = get_field('start_date');
                            $end_date = get_field('end_date');
                            $upload_file = get_field('upload_file');
                            $status = (strtotime($end_date) >= strtotime($today)) ? 'open' : 'closed';
                ?>
                    <tr data-status="<?php echo $status; ?>">
                        <td><?php echo $count++; ?></td>
                        <td><a href="<?php echo esc_url($upload_file); ?>" target="_blank"><?php the_title(); ?></a></td>
                        <td><?php echo esc_html($start_date); ?></td>
                        <td><?php echo esc_html($end_date); ?></td>
                        <td class="text-center">
                            <a href="<?php echo esc_url($upload_file); ?>" target="_blank">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/pdf_icon.png" alt="Download PDF" />
                            </a>
                        </td>
                    </tr>
                <?php 
                        endwhile; 
                        wp_reset_postdata();
                    else:
                        echo '<tr><td colspan="5">No tenders found.</td></tr>';
                    endif;
                ?>
                </tbody>
            </table>
        </div>
    </div>
</section>


 <?php
 get_footer();
