<?php
/**
 * Plugin Name: WP Custom CAPTCHA
 * Description: Adds CAPTCHA protection to login, register, lost password, and comment forms.
 * Version: 1.0
 * Author: Cent Avenue
 * Author URI: https://centavenue.com/
 * License: GPL2
 */

if (!defined('ABSPATH')) exit;

define('WPCC_PATH', plugin_dir_path(__FILE__));
define('WPCC_URL', plugin_dir_url(__FILE__));

require_once WPCC_PATH . 'includes/class-captcha-generator.php';
require_once WPCC_PATH . 'includes/class-settings-page.php';

function wpcc_init() {
    $settings = get_option('wpcc_settings', []);
    if (!is_user_logged_in() || empty($settings['hide_for_logged_in'])) {
        if (!empty($settings['enable_login'])) add_action('login_form', 'wpcc_render_captcha');
        if (!empty($settings['enable_register'])) add_action('register_form', 'wpcc_render_captcha');
        if (!empty($settings['enable_lostpassword'])) add_action('lostpassword_form', 'wpcc_render_captcha');
        if (!empty($settings['enable_comment'])) add_action('comment_form_after_fields', 'wpcc_render_captcha');
    }

    // add_action('login_form_login', 'wpcc_verify_captcha');
    add_action('registration_errors', 'wpcc_verify_captcha', 10, 3);
    add_action('login_form_lostpassword', 'wpcc_verify_lostpassword_captcha');
    add_filter('preprocess_comment', 'wpcc_verify_comment_captcha');
}
add_action('init', 'wpcc_init');

function wpcc_render_captcha() {
    $captcha = new WPCC_Captcha_Generator();
    $captcha->render();
}

function wpcc_verify_login_captcha($user, $username, $password) {
    if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (empty($_POST['wpcc_captcha']) || strtolower($_POST['wpcc_captcha']) !== strtolower($_SESSION['wpcc_captcha'])) {
            return new WP_Error('wpcc_captcha_error', __('Incorrect CAPTCHA. Please try again.', 'wpcc'));
        }
    }
    unset($_SESSION['wpcc_captcha']);
    return $user;
}
add_filter('authenticate', 'wpcc_verify_login_captcha', 30, 3);


function wpcc_verify_register_captcha($errors, $sanitized_user_login, $user_email) {
    session_start();
    if (empty($_POST['wpcc_captcha']) || strtolower($_POST['wpcc_captcha']) !== strtolower($_SESSION['wpcc_captcha'])) {
        $errors->add('wpcc_captcha_error', __('Incorrect CAPTCHA. Please try again.', 'wpcc'));
    }
    unset($_SESSION['wpcc_captcha']);
    return $errors;
}
add_filter('registration_errors', 'wpcc_verify_register_captcha', 10, 3);


function wpcc_verify_lostpassword_captcha() {
    session_start();
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (empty($_POST['wpcc_captcha']) || strtolower($_POST['wpcc_captcha']) !== strtolower($_SESSION['wpcc_captcha'])) {
            add_filter('login_errors', function($error) {
                return __('Incorrect CAPTCHA. Please try again.', 'wpcc');
            });
        }
    }
    unset($_SESSION['wpcc_captcha']);
}



function wpcc_verify_comment_captcha($commentdata) {
    session_start();
    if (empty($_POST['wpcc_captcha']) || strtolower($_POST['wpcc_captcha']) !== strtolower($_SESSION['wpcc_captcha'])) {
        wp_die(__('Incorrect CAPTCHA. Please go back and try again.', 'wpcc'));
    }
    unset($_SESSION['wpcc_captcha']);
    return $commentdata;
}
add_filter('preprocess_comment', 'wpcc_verify_comment_captcha');

    add_action('wp_ajax_wpcc_refresh_captcha', 'wpcc_ajax_refresh_captcha');
    add_action('wp_ajax_nopriv_wpcc_refresh_captcha', 'wpcc_ajax_refresh_captcha');

    function wpcc_ajax_refresh_captcha() {
    session_start();
    $captcha = new WPCC_Captcha_Generator();
    $text = $captcha->generate_captcha();
    $_SESSION['wpcc_captcha'] = $text;
    wp_send_json_success(['captcha' => $text]);
    }
    
    add_action('login_enqueue_scripts', 'wpcc_enqueue_scripts');
    add_action('wp_enqueue_scripts', 'wpcc_enqueue_scripts');
    
    function wpcc_enqueue_scripts() {
        wp_enqueue_script(
            'wpcc-captcha',
            plugin_dir_url(__FILE__) . 'assets/js/wpcc-captcha.js',
            ['jquery'],
            filemtime(plugin_dir_path(__FILE__) . 'assets/js/wpcc-captcha.js'), // dynamic version
            true
        );
        wp_localize_script('wpcc-captcha', 'wpcc_ajax', [
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('wpcc_nonce')
        ]);
    }
    function wpcc_enqueue_captcha_styles() {
    wp_enqueue_style('wpcc-captcha-style', plugin_dir_url(__FILE__) . 'assets/css/wpcc-style.css');
}
add_action('login_enqueue_scripts', 'wpcc_enqueue_captcha_styles'); // Login, Lost Password, Register
add_action('wp_enqueue_scripts', 'wpcc_enqueue_captcha_styles');   // Comments form

    
