<?php
add_action('admin_menu', function() {
    add_options_page('WP CAPTCHA Settings', 'WP CAPTCHA', 'manage_options', 'wpcc-settings', 'wpcc_settings_page');
});

add_action('admin_init', function() {
    register_setting('wpcc_settings_group', 'wpcc_settings');
});

function wpcc_settings_page() {
    ?>
    <div class="wrap">
        <h2>WP CAPTCHA Settings</h2>
        <form method="post" action="options.php">
            <?php
            settings_fields('wpcc_settings_group');
            $settings = get_option('wpcc_settings');
            ?>
            <table class="form-table">
                <tr><th>Enable CAPTCHA for:</th></tr>
                <tr><td><label><input type="checkbox" name="wpcc_settings[enable_login]" <?php checked(!empty($settings['enable_login'])) ?>> Login form</label></td></tr>
                <tr><td><label><input type="checkbox" name="wpcc_settings[enable_register]" <?php checked(!empty($settings['enable_register'])) ?>> Register form</label></td></tr>
                <tr><td><label><input type="checkbox" name="wpcc_settings[enable_lostpassword]" <?php checked(!empty($settings['enable_lostpassword'])) ?>> Lost Password form</label></td></tr>
                <tr><td><label><input type="checkbox" name="wpcc_settings[enable_comment]" <?php checked(!empty($settings['enable_comment'])) ?>> Comment form</label></td></tr>
                <tr><td><label><input type="checkbox" name="wpcc_settings[hide_for_logged_in]" <?php checked(!empty($settings['hide_for_logged_in'])) ?>> Hide for logged in users</label></td></tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}
