<?php
class WPCC_Captcha_Generator {
    public function render() {
        if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
        $captcha_text = $this->generate_captcha();
        $_SESSION['wpcc_captcha'] = $captcha_text;

        ?>
        <div id="wpcc-captcha-container">
            <label for="wpcc_captcha">CAPTCHA: <strong id="wpcc-captcha-text"><?php echo esc_html($captcha_text); ?></strong></label>
            <button type="button" id="wpcc-refresh-captcha" style="margin-left:10px;">🔄 Refresh</button>
            <label>Type the text displayed above:</label>
        </div>
        <input type="text" name="wpcc_captcha" required />
        
        <?php
    }

    public function generate_captcha() {
        $upper = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $lower = 'abcdefghijklmnopqrstuvwxyz';
        $digits = '0123456789';
        $pool = $upper . $lower . $digits;

        // Ensure at least one of each type
        $captcha = $upper[rand(0, 25)];
        $captcha .= $lower[rand(0, 25)];
        $captcha .= $digits[rand(0, 9)];

        // Fill the rest
        for ($i = 3; $i < 6; $i++) {
            $captcha .= $pool[rand(0, strlen($pool) - 1)];
        }

        return str_shuffle($captcha); // Randomize order
    }
}


    
