<?php
/**
 * Prevent XSS Vulnerability About.
 *
 * @package PreventXSSVulnerability
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Create HTML of Plugins' About page.
 */
class Prevent_XSS_Vulnerability_About {
	/**
	 * Call Post Settings Function.
	 */
	public function __construct() {
		$this->more_plugins();
	}

	/**
	 * More Plugins HTML.
	 *
	 * @access private
	 * @since 0.1
	 *
	 * @return void
	 */
	private function more_plugins() {
		$img_src = plugins_url( '/assets/images', PREVENT_XSS_VULNERABILITY_FILE );
		?>

		<div class="wrap">
			<div class="float">
			<h1>
				<?php
					esc_html_e(
						// translators: After `v` there will be a Plugin version.
						// phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
						'Prevent XSS Vulnerability v' . PREVENT_XSS_VULNERABILITY_VERSION,
						'prevent-xss-vulnerability'
					);
				?>
			</h1>
			<div class="tagline">
				<p>
				<?php
				esc_html_e(
					'Thank you for choosing Prevent XSS Vulnerability! I hope, that this plugin helps you to reduce the XSS Attacks on your site.',
					'prevent-xss-vulnerability'
				);
				?>
				</p>
				<p>
				<?php
				esc_html_e(
					'To support future development and to help make it even better please leave a',
					'prevent-xss-vulnerability'
				);
				?>
				<a href="https://wordpress.org/support/plugin/prevent-xss-vulnerability/reviews/?rate=5#new-post" title="Prevent XSS Vulnerability Rating" target="_blank">
				<?php
				esc_html_e( '5-star', 'prevent-xss-vulnerability' );
				?>
				</a>
				<?php
				esc_html_e(
					'rating with a nice message to me :)',
					'prevent-xss-vulnerability'
				);
				?>
				</p>
			</div>
			</div>

			<div class="float">
				<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<img src="<?php echo $img_src . '/prevent-xss-vulnerability.png'; ?>" style="transform:scale(1.5)" alt="<?php esc_html_e( 'Prevent XSS Vulnerability', 'prevent-xss-vulnerability' ); ?>" title="<?php esc_html_e( 'Prevent XSS Vulnerability', 'prevent-xss-vulnerability' ); ?>" />
			</div>

			<div class="product">
			<h2>
				<?php esc_html_e( 'More from Sami Ahmed Siddiqui', 'prevent-xss-vulnerability' ); ?>
				</h2>
			<span>
			<?php
			esc_html_e(
				'Our List of Plugins provides the services which helps you to manage your site URLs(Permalinks), Prevent your site from Brute force attack, change absolute paths to relative, increase your site visitors by adding Structured JSON Markup and so on.',
				'prevent-xss-vulnerability'
			);
			?>
			</span>

			<div class="box recommended">
				<div class="img">
				<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<img src="<?php echo $img_src . '/custom-permalinks.svg'; ?>" alt="<?php esc_html_e( 'Custom Permalinks', 'prevent-xss-vulnerability' ); ?>" title="<?php esc_html_e( 'Custom Permalinks', 'prevent-xss-vulnerability' ); ?>"/>
				</div>

				<h3>
				<?php
				esc_html_e( 'Custom Permalinks', 'prevent-xss-vulnerability' );
				?>
				</h3>
				<p>
				<?php
				esc_html_e( 'Custom Permalinks helps you to make your permalinks customized for <em>individual</em> posts, pages, tags or categories. It will <strong>NOT</strong> apply whole permalink structures, or automatically apply a category\'s custom permalink to the posts within that category.', 'prevent-xss-vulnerability' );
				?>
				</p>
				<a href="https://www.custompermalinks.com/" class="checkout-button" title="<?php esc_html_e( 'Custom Permalinks', 'prevent-xss-vulnerability' ); ?>" target="_blank">
				<?php esc_html_e( 'Check it out', 'prevent-xss-vulnerability' ); ?>
				</a>
			</div>

			<div class="box recommended">
				<div class="img">
				<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<img src="<?php echo $img_src . '/http-auth.svg'; ?>" alt="<?php esc_html_e( 'HTTP Auth', 'prevent-xss-vulnerability' ); ?>" title="<?php esc_html_e( 'HTTP Auth', 'prevent-xss-vulnerability' ); ?>" />
				</div>

				<h3>
				<?php
				esc_html_e( 'HTTP Auth', 'prevent-xss-vulnerability' );
				?>
				</h3>
				<p>
				<?php
				esc_html_e(
					'Allows you apply HTTP Auth on your site. You can apply Http Authentication all over the site or only the admin pages. It helps to stop crawling on your site while on development or persist the Brute Attacks by locking the Admin Pages.',
					'prevent-xss-vulnerability'
				);
				?>
				</p>
				<a href="https://wordpress.org/plugins/http-auth/" class="checkout-button" title="<?php esc_html_e( 'HTTP Auth', 'prevent-xss-vulnerability' ); ?>" target="_blank">
				<?php esc_html_e( 'Check it out', 'prevent-xss-vulnerability' ); ?>
				</a>
			</div>

			<div class="box">
				<div class="img">
				<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<img src="<?php echo $img_src . '/make-paths-relative.svg'; ?>" alt="<?php esc_html_e( 'Make Paths Relative', 'prevent-xss-vulnerability' ); ?>" title="<?php esc_html_e( 'Make Paths Relative', 'prevent-xss-vulnerability' ); ?>" />
				</div>

				<h3>
				<?php
				esc_html_e( 'Make Paths Relative', 'prevent-xss-vulnerability' );
				?>
				</h3>
				<p>
				<?php
				esc_html_e(
					'Convert the paths(URLs) to relative instead of absolute. You can make Post, Category, Archive, Image URLs and Script and Style src as per your requirement. You can choose which you want to be relative from the settings Page.',
					'prevent-xss-vulnerability'
				);
				?>
				</p>
				<a href="https://wordpress.org/plugins/make-paths-relative/" class="checkout-button" title="<?php esc_html_e( 'Make Paths Relative', 'prevent-xss-vulnerability' ); ?>" target="_blank">
				<?php esc_html_e( 'Check it out', 'prevent-xss-vulnerability' ); ?>
				</a>
			</div>

			<div class="box">
				<div class="img">
				<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<img src="<?php echo $img_src . '/schema-for-article.svg'; ?>" alt="<?php esc_html_e( 'SCHEMA for Article', 'prevent-xss-vulnerability' ); ?>" title="<?php esc_html_e( 'SCHEMA for Article', 'prevent-xss-vulnerability' ); ?>" />
				</div>

				<h3>
				<?php
				esc_html_e( 'SCHEMA for Article', 'prevent-xss-vulnerability' );
				?>
				</h3>
				<p>
				<?php
				esc_html_e(
					'Simply the easiest solution to add valid schema.org as a JSON script in the head of blog posts or articles. You can choose the schema either to show with the type of Article or NewsArticle from the settings page.',
					'prevent-xss-vulnerability'
				);
				?>
				</p>
				<a href="https://wordpress.org/plugins/schema-for-article/" class="checkout-button" title="<?php esc_html_e( 'SCHEMA for Article', 'prevent-xss-vulnerability' ); ?>" target="_blank">
				<?php esc_html_e( 'Check it out', 'prevent-xss-vulnerability' ); ?>
				</a>
			</div>

			<div class="box">
				<div class="img">
				<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<img src="<?php echo $img_src . '/remove-links-and-scripts.svg'; ?>" alt="<?php esc_html_e( 'Remove Links and Scripts', 'prevent-xss-vulnerability' ); ?>" title="<?php esc_html_e( 'Remove Links and Scripts', 'prevent-xss-vulnerability' ); ?>" />
				</div>

				<h3>
				<?php
				esc_html_e( 'Remove Links and Scripts', 'prevent-xss-vulnerability' );
				?>
				</h3>
				<p>
				<?php
				esc_html_e(
					'It removes some meta data from the WordPress header so, your header keeps clean of useless information like shortlink, rsd_link, wlwmanifest_link, emoji_scripts, wp_embed, wp_json, emoji_styles, generator and so on.',
					'prevent-xss-vulnerability'
				);
				?>
				</p>
				<a href="https://wordpress.org/plugins/remove-links-and-scripts/" class="checkout-button" title="<?php esc_html_e( 'Remove Links and Scripts', 'prevent-xss-vulnerability' ); ?>" target="_blank">
				<?php esc_html_e( 'Check it out', 'prevent-xss-vulnerability' ); ?>
				</a>
			</div>

			<div class="box">
				<div class="img">
				<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<img src="<?php echo $img_src . '/media-post-permalink.png'; ?>" style="transform:scale(1.5)" alt="<?php esc_html_e( 'Media Post Permalink', 'prevent-xss-vulnerability' ); ?>" title="<?php esc_html_e( 'Media Post Permalink', 'prevent-xss-vulnerability' ); ?>" />
				</div>

				<h3>
				<?php
				esc_html_e( 'Media Post Permalink', 'prevent-xss-vulnerability' );
				?>
				</h3>
				<p>
				<?php
				esc_html_e(
					'On uploading  any image, let\'s say services.png, WordPress creates the attachment post with the permalink of /services/ and doesn\'t allow you to use that permalink to point your page. In this case, we come up with this great solution.',
					'prevent-xss-vulnerability'
				);
				?>
				</p>
				<a href="https://wordpress.org/plugins/media-post-permalink/" class="checkout-button" title="<?php esc_html_e( 'Media Post Permalink', 'prevent-xss-vulnerability' ); ?>" target="_blank">
				<?php esc_html_e( 'Check it out', 'prevent-xss-vulnerability' ); ?>
				</a>
			</div>

			<div class="box">
				<div class="img">
				<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<img src="<?php echo $img_src . '/json-structuring-markup.svg'; ?>" alt="<?php esc_html_e( 'JSON Structuring Markup', 'prevent-xss-vulnerability' ); ?>" title="<?php esc_html_e( 'JSON Structuring Markup', 'prevent-xss-vulnerability' ); ?>" />
				</div>

				<h3>
				<?php
				esc_html_e( 'JSON Structuring Markup', 'prevent-xss-vulnerability' );
				?>
				</h3>
				<p>
				<?php
				esc_html_e(
					'Simply the easiest solution to add valid schema.org as a JSON script in the head of posts and pages. It provides you multiple SCHEMA types like Article, News Article, Organization and Website Schema.',
					'prevent-xss-vulnerability'
				);
				?>
				</p>
				<a href="https://wordpress.org/plugins/json-structuring-markup/" class="checkout-button" title="<?php esc_html_e( 'JSON Structuring Markup', 'prevent-xss-vulnerability' ); ?>" target="_blank">
				<?php esc_html_e( 'Check it out', 'prevent-xss-vulnerability' ); ?>
				</a>
			</div>
			</div>
		</div>
		<?php
	}
}
