<?php
$items = fg_get_gallery_items();
?>

<div class="container py-5 custom-video-gallery">
    <div class="row">
        <?php foreach ($items as $item):
            $videos = get_post_meta($item->ID, '_fancybox_video_gallery_data', true);
            $group_id = 'video-gallery-' . $item->ID;
            if (!empty($videos)) :
                $first = $videos[0];
                $thumb = 'https://img.youtube.com/vi/' . fg_extract_youtube_id($first['url']) . '/mqdefault.jpg';
                $caption = "<strong>" . esc_html($first['title']) . "</strong><br>" . esc_html($first['desc']);
        ?>
            <div class="col-md-3 col-sm-6 mb-4">
                <a href="<?= esc_url($first['url']) ?>" data-fancybox="<?= esc_attr($group_id) ?>" data-caption="<?= esc_attr($caption) ?>">
                    <img src="<?= esc_url($thumb) ?>" class="img-fluid rounded shadow-sm" alt="<?= esc_attr($first['title']) ?>" />
                </a>

                <?php foreach (array_slice($videos, 1) as $vid): ?>
                    <a href="<?= esc_url($vid['url']) ?>"
                       data-fancybox="<?= esc_attr($group_id) ?>"
                       data-caption="<?= esc_attr("<strong>{$vid['title']}</strong><br>{$vid['desc']}") ?>"
                       style="display:none;"></a>
                <?php endforeach; ?>
            </div>
        <?php endif; endforeach; ?>
    </div>
</div>

<?php
// Helper function to extract YouTube ID
function fg_extract_youtube_id($url) {
    preg_match('%(?:youtube\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $url, $matches);
    return $matches[1] ?? '';
}
?>
