<?php
$items = fg_get_gallery_items(); // Get all fg_gallery posts
?>

<div class="container py-5 custom-gallery-section">
    <div class="row">
        <?php foreach ($items as $item): ?>
            <?php
            $gallery_data = get_post_meta($item->ID, '_fancybox_gallery_data', true);
            $group_id = 'gallery-' . $item->ID;
            if (!empty($gallery_data)) :
                // First image for thumbnail
                $first = array_shift($gallery_data);
                $thumb_url = wp_get_attachment_image_url($first['id'], 'medium');
                $full_url  = wp_get_attachment_image_url($first['id'], 'full');
                $caption_title = esc_html($first['title'] ?? '');
                $caption_desc  = esc_html($first['desc'] ?? '');
                $caption_combined = "<strong>{$caption_title}</strong><br>{$caption_desc}";
            ?>
                <div class="col-md-3 col-sm-6 mb-4 gallery-item">
                    <a href="<?= esc_url($full_url) ?>" data-fancybox="<?= esc_attr($group_id) ?>" data-caption="<?= esc_attr($caption_combined) ?>">
                        <div class="image-wrapper">
                            <img src="<?= esc_url($thumb_url) ?>" alt="<?= esc_attr($caption_title) ?>" class="img-fluid rounded shadow-sm" />
                            <div class="overlay"><i class="fa fa-search-plus"></i></div>
                        </div>
                    </a>
                    <p class="image-title"><?= esc_html(get_the_title($item->ID)) ?></p>

                    <?php
                    // Remaining images as hidden links
                    foreach ($gallery_data as $img) {
                        $img_id = $img['id'];
                        $full_url = wp_get_attachment_image_url($img_id, 'full');
                        $title = esc_html($img['title'] ?? '');
                        $desc  = esc_html($img['desc'] ?? '');
                        $caption = "<strong>{$title}</strong><br>{$desc}";
                        if ($full_url):
                    ?>
                        <a href="<?= esc_url($full_url) ?>" data-fancybox="<?= esc_attr($group_id) ?>" data-caption="<?= esc_attr($caption) ?>" style="display: none;"></a>
                    <?php endif; } ?>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</div>

<style>
.custom-gallery-section img {
    transition: transform 0.3s ease;
}
.custom-gallery-section img:hover {
    transform: scale(1.05);
}
.image-title {
    text-align: center;
    font-weight: 500;
    margin-top: 10px;
}
</style>
