<?php
// Enqueue WordPress Media Uploader
add_action('admin_enqueue_scripts', function () {
    wp_enqueue_media();
    wp_enqueue_script('jquery');
});

// Add Meta Box to Custom Post Type
add_action('add_meta_boxes', 'fg_add_custom_meta_box');
function fg_add_custom_meta_box() {
    add_meta_box(
        'custom_fancybox_gallery',
        'Fancybox Gallery',
        'fg_render_fancybox_gallery_meta_box',
        'fg_gallery', // Your custom post type slug
        'normal',
        'default'
    );
}

// Render Meta Box HTML
function fg_render_fancybox_gallery_meta_box($post) {
    $image_data = get_post_meta($post->ID, '_fancybox_gallery_data', true);
    if (!is_array($image_data)) $image_data = [];

    wp_nonce_field('fg_save_gallery_meta_box', 'fg_gallery_meta_box_nonce');

    echo '<ul class="gallery-preview">';
    foreach ($image_data as $index => $item) {
        $img_id = $item['id'];
        $title = esc_attr($item['title'] ?? '');
        $desc  = esc_attr($item['desc'] ?? '');
        $thumb = wp_get_attachment_image($img_id, 'thumbnail');

        echo '<li class="gallery-item" data-index="' . $index . '">';
        echo $thumb;
        echo '<input type="hidden" name="gallery_data['.$index.'][id]" value="' . esc_attr($img_id) . '">';
        echo '<input type="text" name="gallery_data['.$index.'][title]" placeholder="Title" value="'.$title.'" style="display:block;margin-top:5px;width:100%;">';
        echo '<textarea name="gallery_data['.$index.'][desc]" placeholder="Description" style="display:block;margin-top:5px;width:100%;">'.$desc.'</textarea>';
        echo '<button type="button" class="button remove-gallery-item">Remove</button>';
        echo '</li>';
    }
    echo '</ul>';

    echo '<a href="#" class="button upload-gallery-images">Add Images</a>';
    ?>

    <script>
    jQuery(document).ready(function ($) {
        let index = $('.gallery-preview .gallery-item').length;

        $('.upload-gallery-images').on('click', function (e) {
            e.preventDefault();

            const file_frame = wp.media({
                title: 'Select Images',
                button: { text: 'Add to Gallery' },
                multiple: true
            });

            file_frame.on('select', function () {
                const selection = file_frame.state().get('selection');

                selection.each(function (attachment) {
                    attachment = attachment.toJSON();

                    const img = `<li class="gallery-item" data-index="${index}">
                        <img src="${attachment.sizes.thumbnail ? attachment.sizes.thumbnail.url : attachment.url}" />
                        <input type="hidden" name="gallery_data[${index}][id]" value="${attachment.id}">
                        <input type="text" name="gallery_data[${index}][title]" placeholder="Title" style="display:block;margin-top:5px;width:100%;">
                        <textarea name="gallery_data[${index}][desc]" placeholder="Description" style="display:block;margin-top:5px;width:100%;"></textarea>
                        <button type="button" class="button remove-gallery-item">Remove</button>
                    </li>`;

                    $('.gallery-preview').append(img);
                    index++;
                });
            });

            file_frame.open();
        });

        $(document).on('click', '.remove-gallery-item', function () {
            $(this).closest('.gallery-item').remove();
        });
    });
    </script>

    <style>
    .gallery-preview {
        list-style: none;
        padding: 0;
        display: flex;
        flex-wrap: wrap;
        margin-top: 10px;
    }
    .gallery-preview li {
        margin: 10px;
        width: 200px;
        background: #f9f9f9;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 6px;
    }
    .gallery-preview img {
        max-width: 100%;
        border-radius: 4px;
        margin-bottom: 8px;
    }
    .gallery-preview input[type="text"],
    .gallery-preview textarea {
        font-size: 13px;
    }
    </style>
<?php
}

// Save Meta Data
add_action('save_post', function ($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (get_post_type($post_id) !== 'fg_gallery') return;
    if (!isset($_POST['fg_gallery_meta_box_nonce']) || !wp_verify_nonce($_POST['fg_gallery_meta_box_nonce'], 'fg_save_gallery_meta_box')) return;

    if (isset($_POST['gallery_data']) && is_array($_POST['gallery_data'])) {
        $cleaned = [];

        foreach ($_POST['gallery_data'] as $item) {
            $cleaned[] = [
                'id'    => intval($item['id']),
                'title' => sanitize_text_field($item['title'] ?? ''),
                'desc'  => sanitize_textarea_field($item['desc'] ?? ''),
            ];
        }

        update_post_meta($post_id, '_fancybox_gallery_data', $cleaned);
    } else {
        delete_post_meta($post_id, '_fancybox_gallery_data');
    }
});
