<?php
add_action('add_meta_boxes', function () {
    add_meta_box(
        'fancybox_video_gallery',
        'Video Gallery',
        'fg_render_video_gallery_meta_box',
        'fg_gallery',
        'normal',
        'default'
    );
});

function fg_render_video_gallery_meta_box($post) {
    $videos = get_post_meta($post->ID, '_fancybox_video_gallery_data', true) ?: [];
    ?>
    <div id="fg-video-gallery">
        <button type="button" class="button" id="add-video-entry">Add Video</button>
        <div class="fg-video-items">
            <?php foreach ($videos as $index => $video): ?>
                <div class="fg-video-entry">
                    <input type="text" name="video_gallery[<?= $index ?>][url]" value="<?= esc_attr($video['url']) ?>" placeholder="Video URL (MP4, YouTube, Vimeo)" class="widefat" />
                    <input type="text" name="video_gallery[<?= $index ?>][title]" value="<?= esc_attr($video['title']) ?>" placeholder="Title" class="widefat" />
                    <textarea name="video_gallery[<?= $index ?>][desc]" placeholder="Description" class="widefat"><?= esc_textarea($video['desc']) ?></textarea>
                    <button type="button" class="button remove-video-entry">Remove</button>
                    <hr>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <script>
        jQuery(function($) {
            let videoIndex = <?= count($videos) ?>;

            $('#add-video-entry').on('click', function() {
                const html = `
                <div class="fg-video-entry">
                    <input type="text" name="video_gallery[${videoIndex}][url]" placeholder="Video URL (MP4, YouTube, Vimeo)" class="widefat" />
                    <input type="text" name="video_gallery[${videoIndex}][title]" placeholder="Title" class="widefat" />
                    <textarea name="video_gallery[${videoIndex}][desc]" placeholder="Description" class="widefat"></textarea>
                    <button type="button" class="button remove-video-entry">Remove</button>
                    <hr>
                </div>`;
                $('.fg-video-items').append(html);
                videoIndex++;
            });

            $(document).on('click', '.remove-video-entry', function() {
                $(this).closest('.fg-video-entry').remove();
            });
        });
    </script>

    <style>
        .fg-video-entry {
            background: #f9f9f9;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
        }
    </style>
    <?php
}

add_action('save_post', function ($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (get_post_type($post_id) !== 'fg_gallery') return;

    if (isset($_POST['video_gallery']) && is_array($_POST['video_gallery'])) {
        $cleaned = array_map(function ($item) {
            return [
                'url' => esc_url_raw($item['url']),
                'title' => sanitize_text_field($item['title']),
                'desc' => sanitize_textarea_field($item['desc']),
            ];
        }, $_POST['video_gallery']);

        update_post_meta($post_id, '_fancybox_video_gallery_data', $cleaned);
    }
});
