<?php
$items = fg_get_gallery_items();
?>
<div class="container py-5 custom-gallery-section">
    <div class="row">
        <?php foreach ($items as $item): ?>
            <?php
            $caption = get_the_title($item->ID);
            $image_ids = get_post_meta($item->ID, '_fancybox_gallery_images', true);
            if (!empty($image_ids)) {
                $ids_array = explode(',', $image_ids);
                $group_id = 'gallery-' . $item->ID;
                $first_image_id = array_shift($ids_array); // remove and get the first image
                $thumb_url = wp_get_attachment_image_url($first_image_id, 'medium');
                $full_url = wp_get_attachment_image_url($first_image_id, 'full');
            ?>
            <div class="col-md-3 col-sm-6 mb-4 gallery-item">
                <a href="<?= esc_url($full_url) ?>" data-fancybox="<?= esc_attr($group_id) ?>" data-caption="<?= esc_attr($caption) ?>">
                    <div class="image-wrapper" data-title="<?= esc_attr($caption) ?>">
                        <img src="<?= esc_url($thumb_url) ?>" alt="<?= esc_attr($caption) ?>" />
                    </div>
                </a>
                <p class="image-title" title="<?= esc_attr($caption) ?>"><?= esc_html($caption) ?></p>

                <?php
                // Output remaining images as hidden links
                foreach ($ids_array as $img_id):
                    $hidden_full_url = wp_get_attachment_image_url($img_id, 'full');
                    if ($hidden_full_url):
                ?>
                    <a href="<?= esc_url($hidden_full_url) ?>" data-fancybox="<?= esc_attr($group_id) ?>" data-caption="<?= esc_attr($caption) ?>" style="display:none;"></a>
                <?php
                    endif;
                endforeach;
                ?>
            </div>
            <?php } ?>
        <?php endforeach; ?>
    </div>
</div>
