<?php
// Enqueue WordPress Media Uploader
add_action('admin_enqueue_scripts', function () {
    wp_enqueue_media();
    wp_enqueue_script('jquery');
});

// Add Meta Box to Custom Post Type
add_action('add_meta_boxes', 'fg_add_custom_meta_box');
function fg_add_custom_meta_box() {
    add_meta_box(
        'custom_fancybox_gallery',
        'Fancybox Gallery',
        'fg_render_fancybox_gallery_meta_box',
        'fg_gallery', // ← change to your CPT if different
        'normal',
        'default'
    );
}

// Render Meta Box HTML
function fg_render_fancybox_gallery_meta_box($post) {
    $image_ids = get_post_meta(get_the_ID(), '_fancybox_gallery_images', true);

if ($image_ids) {
    $ids_array = explode(',', $image_ids);

    echo '<div class="my-gallery">';
    foreach ($ids_array as $id) {
        $img_url = wp_get_attachment_image_url($id, 'medium');
        echo '<img src="' . esc_url($img_url) . '" style="margin:10px;" />';
    }
    echo '</div>';
}

    ?>
    <div>
        <a href="#" class="button upload-gallery-images">Upload Images</a>
        <ul class="gallery-preview">
            <?php
            if ($image_ids) {
                foreach (explode(',', $image_ids) as $image_id) {
                    echo '<li data-id="' . esc_attr($image_id) . '">';
                    echo wp_get_attachment_image($image_id, 'thumbnail');
                    echo '</li>';
                }
            }
            ?>
        </ul>
        <input type="hidden" name="fancybox_gallery_images" value="<?php echo esc_attr($image_ids); ?>">
    </div>

    <script>
jQuery(document).ready(function ($) {
    $('.upload-gallery-images').on('click', function (e) {
        e.preventDefault();

        const file_frame = wp.media({
            title: 'Select Images',
            button: { text: 'Add to Gallery' },
            multiple: true
        });

        file_frame.on('select', function () {
            const selection = file_frame.state().get('selection');
            let ids = [];
            let preview = '';

            selection.each(function (attachment) {
                attachment = attachment.toJSON();
                ids.push(attachment.id);

                let imgSrc = (attachment.sizes && attachment.sizes.thumbnail)
                    ? attachment.sizes.thumbnail.url
                    : attachment.url;

                preview += '<li data-id="' + attachment.id + '"><img src="' + imgSrc + '" /></li>';
            });

            // 👇 Append to existing image IDs
            const existingVal = $('input[name="fancybox_gallery_images"]').val();
            let existingIds = existingVal ? existingVal.split(',') : [];

            // Merge and remove duplicates
            const allIds = [...new Set(existingIds.concat(ids.map(String)))];

            $('input[name="fancybox_gallery_images"]').val(allIds.join(','));

            // Append new thumbnails
            $('.gallery-preview').append(preview);
        });

        file_frame.open();
    });
});
</script>




    <style>
        .gallery-preview { list-style: none; padding: 0; display: flex; flex-wrap: wrap; margin-top: 10px; }
        .gallery-preview li { margin: 5px; }
        .gallery-preview img { max-width: 100px; border-radius: 4px; }
    </style>
    <?php
}

// Save Meta Data
add_action('save_post', function ($post_id) {
    // Avoid auto-saves
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    // Check if this is the correct post type
    if (get_post_type($post_id) !== 'fg_gallery') return;

    // Check for nonce or capabilities (optional security)
    if (isset($_POST['fancybox_gallery_images'])) {
        $image_ids = sanitize_text_field($_POST['fancybox_gallery_images']);
        update_post_meta($post_id, '_fancybox_gallery_images', $image_ids);
    }
});


