<?php
/**
 * Plugin Name: Fancybox Gallery
 * Description: A responsive FancyBox-based photo/video gallery plugin with album and tag support.
 * Version: 1.0
 * Author: Your Name
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'FG_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'FG_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

require_once FG_PLUGIN_PATH . 'includes/post-types.php';
require_once FG_PLUGIN_PATH . 'includes/functions.php';
require_once FG_PLUGIN_PATH . 'includes/admin-menu.php';
require_once FG_PLUGIN_PATH . 'includes/meta-box.php';


function fg_enqueue_scripts() {
    if (get_option('fg_enable_fancybox', 1)) {
        wp_enqueue_style('fancybox-css', 'https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css');
        wp_enqueue_script('fancybox-js', 'https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.umd.js', ['jquery'], null, true);
    }

    wp_enqueue_script('jquery');
    wp_enqueue_style('fg-gallery-style', FG_PLUGIN_URL . 'assets/css/gallery-style.css');
    wp_enqueue_script('fg-gallery-script', FG_PLUGIN_URL . 'assets/js/gallery-script.js', ['jquery'], null, true);
}

add_action( 'wp_enqueue_scripts', 'fg_enqueue_scripts' );

// Shortcode
function fg_gallery_shortcode( $atts ) {
    ob_start();
    include FG_PLUGIN_PATH . 'templates/gallery-template.php';
    return ob_get_clean();
}
add_shortcode( 'fancybox_gallery', 'fg_gallery_shortcode' );

// Enforce Role Permissions

// Check User Role Safely (used only inside hooked functions)
function fg_user_can_manage_gallery() {
    if (!function_exists('wp_get_current_user')) {
        require_once ABSPATH . 'wp-includes/pluggable.php';
    }

    $current_user = wp_get_current_user();
    if (!$current_user instanceof WP_User) {
        return false;
    }

    $allowed_roles = get_option('fg_allowed_roles', ['administrator']);
    return !empty(array_intersect($allowed_roles, $current_user->roles));
}
